<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->double('price');
			$table->text('description')->nullable();
			$table->string('company')->nullable();
			$table->json('images')->nullable();
			$table->bigInteger('currency_id')->unsigned();
			$table->bigInteger('store_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}