<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EquipmentDet extends Model 
{

    protected $table = 'equipment_det';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'equipment_id', 'color_code', 'insp_date', '3party_date', 'join_date', 'date_color', 'notes');

    public function equipment()
    {
        return $this->belongsTo('Equipment', 'equipment_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}