<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'project';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'pm', 'hse_manager', 'owner', 'sector_id', 'status');

    public function sector()
    {
        return $this->belongsTo('Sector', 'sector_id');
    }

}