<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Witness extends Model 
{

    protected $table = 'witness';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'position', 'statement', 'national_id', 'hr_code', 'incident_id');

    public function incident()
    {
        return $this->belongsTo('Incident', 'incident_id');
    }

}