<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('event', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('type_id')->nullable();
			$table->integer('project_id')->nullable();
			$table->string('issuer')->nullable();
			$table->integer('engineer_id')->nullable();
			$table->string('event_location')->nullable();
			$table->string('reference')->nullable();
			$table->text('description')->nullable();
			$table->integer('category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('event');
	}
}