<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncidentTable extends Migration {

	public function up()
	{
		Schema::create('incident', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('date')->nullable();
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('activity_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->integer('direct_manager_id')->nullable();
			$table->string('time')->nullable();
			$table->string('investigation_team')->nullable();
			$table->string('incident_location')->nullable();
			$table->string('incident_category')->nullable();
			$table->integer('project_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('incident');
	}
}