<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaintenanceLogTable extends Migration {

	public function up()
	{
		Schema::create('maintenance_log', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('equipment_id')->nullable();
			$table->integer('project_id')->nullable();
			$table->string('task')->nullable();
			$table->string('performer')->nullable();
			$table->text('note')->nullable();
			$table->datetime('date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('maintenance_log');
	}
}