<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTheCaseTable extends Migration {

	public function up()
	{
		Schema::create('the_case', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->datetime('date_of_birth')->nullable();
			$table->integer('exp')->nullable();
			$table->datetime('start_date')->nullable();
			$table->integer('direct_manager_id')->nullable();
			$table->string('occupation')->nullable();
			$table->string('national_id')->nullable();
			$table->integer('hr_code')->nullable();
			$table->string('nature_of_injury')->nullable();
			$table->string('place_of_injury')->nullable();
			$table->integer('incident_id')->nullable();
			$table->integer('injury_type_id')->nullable();
			$table->string('no_of_lti')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('the_case');
	}
}