<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cause extends Eloquent {

	protected $table = 'cause';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'type', 'incident_id');

	public function incident()
	{
		return $this->belongsTo('Incident', 'incident_id');
	}

}