<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventClosure extends Eloquent {

	protected $table = 'event_closure';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'closure_date', 'event_id', 'equipment_id', 'due_date', 'status');

	public function event()
	{
		return $this->belongsTo('Event', 'event_id');
	}

	public function equipment()
	{
		return $this->belongsTo('Equipment', 'equipment_id');
	}

}