<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sector extends Model 
{

    protected $table = 'sector';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'bu_director');

    public function projects()
    {
        return $this->hasMany('Project', 'sector_id');
    }

}