<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Statistic extends Model 
{

    protected $table = 'statistic';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'man_power', 'man_hour', 'date');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}