<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function product_reviews()
	{
		return $this->hasMany('App\Models\ProductReview');
	}

	public function option_values()
	{
		return $this->belongsToMany('App\Models\OptionValue')->withPivot('option_price');
	}

}