<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name');
			$table->string('last_name')->nullable();
			$table->string('full_name');
			$table->string('avatar')->nullable();
			$table->string('username')->unique();
			$table->string('password');
			$table->string('email')->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('email_verification_code')->nullable();
			$table->string('role');
			$table->boolean('active')->default(1);
			$table->string('lang', 10)->default('en');
			$table->boolean('first_login')->default(0);
			$table->string('remember_token', 100)->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}