<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWpPostsTable extends Migration {

	public function up()
	{
		Schema::create('wp_posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('post_author')->index();
			$table->datetime('post_date')->index();
			$table->datetime('post_date_gmt');
			$table->longText('post_content');
			$table->text('post_title');
			$table->text('post_excerpt');
			$table->string('post_status', 20)->index();
			$table->string('comment_status', 20);
			$table->string('ping_status', 20);
			$table->string('post_password', 20);
			$table->string('post_name', 200)->index();
			$table->text('to_ping');
			$table->text('pinged');
			$table->datetime('post_modified');
			$table->datetime('post_modified_gmt');
			$table->longText('post_content_filtered');
			$table->bigInteger('post_parent')->index();
			$table->string('guid', 255);
			$table->integer('menu_order');
			$table->string('post_type', 20);
			$table->string('post_mime_type', 100);
			$table->bigInteger('comment_count');
		});
	}

	public function down()
	{
		Schema::drop('wp_posts');
	}
}