<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function doyatStories()
    {
        return $this->hasMany('Doyat');
    }

    public function chitralekh()
    {
        return $this->hasMany('Chitralekh');
    }

    public function roles()
    {
        return $this->hasMany('Role');
    }

    public function funds()
    {
        return $this->hasMany('Fund');
    }

}