<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutletsTable extends Migration {

	public function up()
	{
		Schema::create('outlets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('franchise_id');
			$table->integer('outlet_id');
			$table->string('name');
			$table->string('sap_id');
			$table->string('hub_id');
			$table->string('region');
			$table->string('zone');
			$table->string('latitude');
			$table->string('longitude');
			$table->string('ip_address');
			$table->boolean('connected');
			$table->datetime('connected_at');
			$table->datetime('disconnected_at');
			$table->string('type');
			$table->string('version');
		});
	}

	public function down()
	{
		Schema::drop('outlets');
	}
}