<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_outlet_id_foreign');
		});
	}
}