<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('email')->nullable();
			$table->string('writer_name')->nullable();
			$table->longText('content');
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}