<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('id_categoria_blog')->references('id')->on('categorias_blog')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitoras', function(Blueprint $table) {
			$table->foreign('id_rol')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('experiencia', function(Blueprint $table) {
			$table->foreign('id_monitora')->references('id')->on('monitoras')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('id_categoria')->references('id')->on('categorias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_id_categoria_blog_foreign');
		});
		Schema::table('monitoras', function(Blueprint $table) {
			$table->dropForeign('monitoras_id_rol_foreign');
		});
		Schema::table('experiencia', function(Blueprint $table) {
			$table->dropForeign('experiencia_id_monitora_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_id_categoria_foreign');
		});
	}
}