<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Utilisateur extends Model 
{

    protected $table = 'Utilisateurs';
    public $timestamps = true;

    public function adresses()
    {
        return $this->hasMany('Adresse');
    }

    public function emails()
    {
        return $this->hasMany('Email');
    }

    public function telephones()
    {
        return $this->hasMany('Telephone');
    }

    public function tresoreries()
    {
        return $this->hasMany('Tresorerie');
    }

    public function professions()
    {
        return $this->hasMany('Profession');
    }

    public function regimeutilisateurs()
    {
        return $this->hasMany('Regime_Utilisateur');
    }

    public function simulations()
    {
        return $this->hasMany('Simulation');
    }

    public function mobiliers()
    {
        return $this->hasMany('Mobilier');
    }

    public function immobiliers()
    {
        return $this->hasManyThrough('Immobilier', 'adresse');
    }

}