<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function productValues()
	{
		return $this->hasMany('ProductValue');
	}

	public function productTypes()
	{
		return $this->hasOne('ProductType');
	}

	public function productVariants()
	{
		return $this->hasMany('ProductVariant');
	}

}