<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model 
{

    protected $table = 'partners';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'url', 'logo_image');

    public function coupons()
    {
        return $this->hasMany('Coupon');
    }

    public function importers()
    {
        return $this->hasMany('Importer');
    }

    public function paymentTypes()
    {
        return $this->hasMany('PaymentType');
    }

}