<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImportersTable extends Migration {

	public function up()
	{
		Schema::create('importers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('partner_id');
			$table->integer('currency_id');
			$table->string('feed_url', 1024);
			$table->text('configuration');
			$table->text('mapping')->nullable();
			$table->string('class', 255);
			$table->time('runtime');
			$table->boolean('running')->default(0);
			$table->boolean('active')->default(1);
			$table->datetime('last_run_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('importers');
	}
}