<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTable extends Migration {

	public function up()
	{
		Schema::create('discount', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200)->unique();
			$table->string('description', 250);
			$table->timestamp('started_at');
			$table->timestamp('ended_at');
			$table->string('type', 25);
			$table->float('value');
			$table->string('ship_discount_type', 25);
			$table->float('ship_discount_value');
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
			$table->timestamp('updated_at');
			$table->timestamp('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('discount');
	}
}