<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountableTable extends Migration {

	public function up()
	{
		Schema::create('discountable', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('discount_id')->unsigned();
			$table->text('description');
			$table->string('discountable_type', 255);
			$table->string('user_id', 200);
			$table->string('user_group_id', 200);
			$table->string('brand_id', 200);
			$table->string('product_category_id', 200);
			$table->string('product_id');
			$table->tinyInteger('status');
			$table->timestamp('created_at');
			$table->softDeletes();
			$table->timestamp('updated_at');
			$table->timestamp('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('discountable');
	}
}