<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCounselingsTable extends Migration {

	public function up()
	{
		Schema::create('counselings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ac_id')->unsigned();
			$table->integer('st_id')->unsigned();
			$table->string('st_name', 100)->nullable();
			$table->string('pt_name', 100)->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('email', 255)->nullable();
			$table->timestamp('cs_at')->nullable();
			$table->string('title', 255)->nullable();
			$table->text('content');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('counselings');
	}
}