<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFamiliesTable extends Migration {

	public function up()
	{
		Schema::create('families', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('st_id')->unsigned();
			$table->string('relation', 50);
			$table->string('name', 100)->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('job', 100)->nullable();
			$table->string('memo', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('families');
	}
}