<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ac_id')->unsigned();
			$table->enum('scope', array('class', 'academy', 'global'));
			$table->timestamp('start_at');
			$table->tinyInteger('is_allday');
			$table->tinyInteger('is_holiday');
			$table->string('name', 100);
			$table->string('nickname', 100)->nullable();
			$table->string('place', 100)->nullable();
			$table->string('description', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}