<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDegreeIntrosTable extends Migration {

	public function up()
	{
		Schema::create('degree_intros', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ac_id')->unique()->unsigned();
			$table->date('year_month')->unique();
			$table->string('title', 255)->nullable();
			$table->string('content', 500)->nullable();
			$table->string('image')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('degree_intros');
	}
}