<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiariesTable extends Migration {

	public function up()
	{
		Schema::create('diaries', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('daily', 'weekly', 'monthly'));
			$table->date('rec_date');
			$table->string('absent_students', 500)->nullable();
			$table->string('injured_students', 500)->nullable();
			$table->string('birthday_students', 500)->nullable();
			$table->string('event', 500)->nullable();
			$table->string('note', 500)->nullable();
			$table->string('feedback', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('diaries');
	}
}