<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionnairesTable extends Migration {

	public function up()
	{
		Schema::create('questionnaires', function(Blueprint $table) {
			$table->increments('id');
			$table->string('media_type')->index();
			$table->jsonb('media_paths');
			$table->string('title', 255)->index();
			$table->text('content')->nullable();
			$table->datetime('start_at')->index();
			$table->datetime('end_at')->index();
			$table->boolean('cond_enable')->index();
			$table->integer('cond_age_from')->nullable()->index();
			$table->integer('cond_age_to')->nullable()->index();
			$table->char('cond_gender', 1)->nullable()->index();
			$table->string('cond_area')->nullable()->index();
			$table->datetime('published_at')->nullable();
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('questionnaires');
	}
}