<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlaceReservesTable extends Migration {

	public function up()
	{
		Schema::create('place_reserves', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('place_id')->index();
			$table->integer('user_id')->index();
			$table->datetime('reserved_at')->index();
			$table->string('checkin_at')->nullable();
			$table->datetime('checkout_at')->nullable()->index();
			$table->datetime('reserved_date')->index();
			$table->datetime('reserved_time_from')->index();
			$table->datetime('reserved_time_to')->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('place_reserves');
	}
}