<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceItemsTable extends Migration {

	public function up()
	{
		Schema::create('service_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('serviceId')->unsigned();
			$table->text('description');
			$table->text('note');
			$table->enum('rateFrequency', array('hourly', 'monthly', 'fixed'));
			$table->float('amount');
			$table->integer('percentageEffort');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_items');
	}
}