<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('api_token', 400)->nullable();
			$table->integer('pin_code')->nullable();
			$table->string('remember_token')->nullable();
			$table->integer('vendor_id')->nullable();
			$table->smallInteger('activity')->default('0');
			$table->string('password', 400);
			$table->integer('location_id')->nullable();
			$table->integer('building_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->smallInteger('type')->default('0');
			$table->smallInteger('status')->default('0');
			$table->integer('job_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}