<?php

namespace App\models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'name_en', 'vendor_id', 'img', 'activity', 'parent_id', 'has_damages', 'has_employees', 'has_products');

	public function vendor()
	{
		return $this->belongsTo('App\models\Vendor');
	}

	public function damages()
	{
		return $this->hasMany('App\models\Damage');
	}

}