<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BloodType extends Eloquent {

	protected $table = 'blood_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\Donationrequest');
	}

	public function users()
	{
		return $this->hasMany('App\Models\Client');
	}

}