<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'governorate_id');

	public function governorate()
	{
		return $this->belongsTo('App\Models\Governorate');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\Donationrequest');
	}

	public function clients()
	{
		return $this->hasMany('App\Models\Client');
	}

}