<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->string('site_name', 191);
			$table->string('logo', 191);
			$table->string('icon', 191);
			$table->string('email', 191)->nullable();
			$table->text('descriprion')->nullable();
			$table->text('keywords')->nullable();
			$table->enum('status', array('open', 'close'))->nullable();
			$table->string('fb', 191)->nullable();
			$table->string('tw', 191)->nullable();
			$table->string('ytube', 191)->nullable();
			$table->string('in', 191)->nullable();
			$table->string('whats_app', 191)->nullable();
			$table->text('notification_settings_text')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}