<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePupilsTable extends Migration {

	public function up()
	{
		Schema::create('pupils', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('admno', 20);
			$table->datetime('admdate');
			$table->date('dateofbirth')->nullable();
			$table->integer('parent_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->timestamps();
			$table->integer('updated_by')->unsigned();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pupils');
	}
}