<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Classpupil extends Eloquent {

	protected $table = 'classPupil';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pupil_id', 'class_id', 'year');
	protected $visible = array('pupil_id', 'class_id');

	public function pupil()
	{
		return $this->belongsTo('Pupil');
	}

	public function class()
	{
		return $this->belongsTo('Class');
	}

}