<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Classpupil extends Model 
{

    protected $table = 'classPupil';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('pupil_id', 'class_id', 'year');
    protected $visible = array('pupil_id', 'class_id');

    public function pupil()
    {
        return $this->belongsTo('Pupil');
    }

    public function class()
    {
        return $this->belongsTo('Class');
    }

}