<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountryTable extends Migration {

	public function up()
	{
		Schema::create('country', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->tinyInteger('acitve')->default('1');
			$table->string('phone_key', 10)->nullable();
			$table->string('code_number', 10)->unique()->nullable();
			$table->string('name_cut', 10)->nullable();
			$table->string('currencies_ar', 100)->nullable();
			$table->string('currencies_en', 191)->nullable();
			$table->string('currencies_cut', 10)->nullable();
			$table->string('exchange_rate', 191)->nullable();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('country');
	}
}