<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCriteriesTable extends Migration {

	public function up()
	{
		Schema::create('criteries', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26);
			$table->string('code', 50)->nullable();
			$table->string('name', 100)->index();
			$table->string('description')->nullable();
			$table->integer('group_id')->unsigned()->index()->default('0');
			$table->jsonb('properties')->nullable();
			$table->jsonb('matrix');
			$table->jsonb('matrix_level');
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('criteries');
	}
}