<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Commande extends Eloquent {

	protected $table = 'commandes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id', 'date_commande', 'user_id', 'statut_commande');
	protected $visible = array('prix_total');

	public function relationUser()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function relationLigneCommande()
	{
		return $this->hasOne('App\Models\LigneCommande');
	}

}