<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationCommissionsTable extends Migration {

	public function up()
	{
		Schema::create('application_commissions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_id')->nullable();
			$table->enum('type', array('reset', 'order'));
			$table->float('commission');
			$table->float('after_commission')->default('0');
			$table->float('amount');
			$table->float('before_commission');
			$table->string('commissionable_type');
			$table->integer('commissionable_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('application_commissions');
	}
}