<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->foreign('executor_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('issues', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('claims', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('claims', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('redeems', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('redeems', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_owner_id_foreign');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->dropForeign('task_executions_task_id_foreign');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->dropForeign('task_executions_executor_id_foreign');
		});
		Schema::table('task_executions', function(Blueprint $table) {
			$table->dropForeign('task_executions_admin_id_foreign');
		});
		Schema::table('issues', function(Blueprint $table) {
			$table->dropForeign('issues_user_id_foreign');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->dropForeign('wallets_user_id_foreign');
		});
		Schema::table('claims', function(Blueprint $table) {
			$table->dropForeign('claims_user_id_foreign');
		});
		Schema::table('claims', function(Blueprint $table) {
			$table->dropForeign('claims_admin_id_foreign');
		});
		Schema::table('redeems', function(Blueprint $table) {
			$table->dropForeign('redeems_user_id_foreign');
		});
		Schema::table('redeems', function(Blueprint $table) {
			$table->dropForeign('redeems_admin_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
	}
}