<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccreditationsTable extends Migration {

	public function up()
	{
		Schema::create('accreditations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('decision_approved');
			$table->integer('rating_scope')->nullable();
			$table->integer('stem_hours')->default('0');
			$table->integer('s1')->default('0');
			$table->integer('s2')->default('0');
			$table->integer('s3')->nullable();
			$table->bigInteger('evaluator_id')->unsigned()->nullable();
			$table->integer('s4')->nullable();
			$table->integer('s5')->nullable();
			$table->integer('s6')->nullable();
			$table->enum('status', array('proposal', 'concept', 'request', 'rating', 'rating-done'));
			$table->integer('s7')->nullable();
			$table->integer('s8')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('accreditations');
	}
}