<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('media_type', 255);
			$table->string('url', 1024)->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}