<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reference_properties', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('reference_entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->foreign('parent_property_id')->references('id')->on('reference_properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->foreign('parent_entity_id')->references('id')->on('reference_entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->foreign('child_property_id')->references('id')->on('reference_properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->foreign('child_entity_id')->references('id')->on('reference_entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->foreign('rfq_id')->references('quote_id')->on('quote')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('reference_properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('reference_entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('reference_properties', function(Blueprint $table) {
			$table->dropForeign('reference_properties_entity_id_foreign');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->dropForeign('reference_relationships_parent_property_id_foreign');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->dropForeign('reference_relationships_parent_entity_id_foreign');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->dropForeign('reference_relationships_child_property_id_foreign');
		});
		Schema::table('reference_relationships', function(Blueprint $table) {
			$table->dropForeign('reference_relationships_child_entity_id_foreign');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->dropForeign('configuration_properties_rfq_id_foreign');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->dropForeign('configuration_properties_property_id_foreign');
		});
		Schema::table('configuration_properties', function(Blueprint $table) {
			$table->dropForeign('configuration_properties_entity_id_foreign');
		});
	}
}